uniform float u_kernel[9];
varying vec2 v_texCoord;
varying vec2 v_offsets[9];
uniform float u_useFilter;

void main()
{
    vec4 colorAcc = vec4(0.0, 0.0, 0.0, 0.0);
    vec4 color;
    vec4 attribs;
    
    if(u_useFilter> 0.5){
        for (int i = 0; i < 9; i++) {
            color = texture2D(CC_Texture1, v_offsets[i]);
            colorAcc += u_kernel[i] * color * color.a / 0.9 * (1.0 - step(0.9,color.a));
        }
        //colorAcc.a /= 1.9;
    }else{
        for (int i = 0; i < 9; i++) {
            color = texture2D(CC_Texture1, v_offsets[i]);
            colorAcc += u_kernel[i] * color;
        }
        //colorAcc.a /= 1.9;
    }
    

    gl_FragColor = colorAcc;
}
